function nodeSimilarity(obj,varargin)
%NODESIMILARITY Calculate similarity matrix for this SimilarityMatrix
%object using the node similarity algorithm (ask Adam Bloniarz what this
%is)
%Optional parameters:
%   'quiet' - should be true or false; true to suppress output of
%      convergence information


quiet = false;


for i = 1:2:numel(varargin)
    switch varargin{i}
        case 'quiet'
            quiet = varargin{i+1};
    end
end



[A obj.Slabels] = getSquareMatrix(obj.adjMat);


switch obj.direction
    case 'outgoing'
        idxs = (sum(A,2) == 0);
        A(idxs,:) = [];
        A(:,idxs') = [];
        obj.Slabels(idxs) = [];
    case 'incoming'
        idxs = (sum(A,1) == 0);
        A(idxs',:) = [];
        A(:,idxs) = [];
        obj.Slabels(idxs) = [];
end

S = sparse(eye(size(A)));
S2 = S;
if ~quiet, fprintf('Epsilon for convergence of similarity matrix:\n'); end
denom = 1;
for i = 1:500
    %     S
    %     input('press enter for next iteration','s')
    S2 = updateSimilarity(A,S,obj.direction,obj.similarityMethod);
    if ~quiet
        diff = norm(S2-S,'fro');
        fprintf('%.10f\n',diff);
    end
    
    switch obj.updateMethod
        case 'weighted'
            S = (denom*S + S2/(i))/(denom+1/i);    % Weighted average of the matrices
            denom = denom + 1/i;
        case 'solution'
            S = S2;         %Normal method
        case 'average'
            S = (i*S + S2) /(i+1);   %Average
    end
end

m = full(min(S(:)));
[I J] = find(S == m);

if ~quiet
    fprintf('Minimum similarity: %.10f, between %s and %s\n',m,obj.Slabels{I(1)},obj.Slabels{J(1)});
    tmp = triu(S,1);
    hist(tmp(tmp>0),max(10,size(S,1)/10)); title('Histogram of similarity values');
end
obj.S = S;


end

